//%attributes = {"publishedSql":true}
// Method: _sql_ Dialect
// 2003.10.15-16:00:27 / Pasi Mankinen
// © Copyright 2003 Manage Applications
// Purpose: 
// returns standars sql sentence in used database dialect
// ------------------------------------------------------------
C_TEXT:C284($0; $1)
Case of 
	: ($1="Dialect")
		$0:=_sql_tDialect  //return self
	: ((_sql_tDialect="MySql") & ($1="LOWER"))
		$0:=""
	: ((_sql_tDialect="MySql") & ($1="LOWER_ORDER"))
		$0:=""
	: ((_sql_tDialect="Solid") & ($1="LOWER_ORDER"))
		$0:=""
	: ((_sql_tDialect="Solid") & ($1="LOWER"))
		$0:="LOWER"
		
	: ((_sql_tDialect="Postgre") & ($1="LIKE"))  //we also use LOWER(fld)=_str_ ToLower(value)
		$0:="ILIKE"  //case insensitive like      
	: ((_sql_tDialect="Postgre") & ($1="0000-00-00 @"))  //datetime
		$0:=ksQuoteSingle+"1970-01-01 "+Substring:C12($1; 12)+ksQuoteSingle
	: ((_sql_tDialect="Postgre") & ($1="0000-00-00"))  //date
		$0:=ksQuoteSingle+"1970-01-01"+ksQuoteSingle
	: ((_sql_tDialect="Postgre") & ($1="00:00:00"))  //time
		$0:=ksQuoteSingle+"00:00:00"+ksQuoteSingle
		
	: ((_sql_tDialect="SqlServer") & ($1="0000-00-00 @"))  //datetime
		$0:=ksQuoteSingle+"1970-01-01 "+Substring:C12($1; 12)+ksQuoteSingle
	: ((_sql_tDialect="SqlServer") & ($1="0000-00-00"))  //date
		$0:=ksQuoteSingle+"1970-01-01"+ksQuoteSingle
	: ((_sql_tDialect="SqlServer") & ($1="00:00:00"))  //time
		$0:=ksQuoteSingle+"00:00:00"+ksQuoteSingle
		
	: ((_sql_tDialect="MySql") & ($1="||"))
		$0:="CONCAT("+ksTab+","+ksTab+")"  //start, separator, end
	: ((_sql_tDialect="SqlServer") & ($1="||"))
		$0:="+"
	: ((_sql_tDialect="Access") & ($1="||"))
		$0:="+"
	: ((_sql_tDialect="Access") & ($1="LOWER"))
		$0:="LCASE"
	: ((_sql_tDialect="Access") & ($1="LOWER_ORDER"))
		$0:="LCASE"
		
	: ((_sql_tDialect="SqlServer") & ($1="CREATE LOCAL TEMPORARY TABLE"))  //sql syntax by PM
		$0:="CREATE TABLE##"
	: ((_sql_tDialect="Access") & ($1="CREATE LOCAL TEMPORARY TABLE"))
		$0:="CREATE TABLE"
		
	: ((_sql_tDialect="SqlServer") & ($1="CREATE GLOBAL TEMPORARY TABLE"))  //sql syntax by PM
		$0:="CREATE TABLE#"
	: ((_sql_tDialect="Access") & ($1="CREATE GLOBAL TEMPORARY TABLE"))
		$0:="CREATE TABLE"
		
	: ((_sql_tDialect="MySql") & ($1="USE DATABASE"))  //sql syntax by PM
		$0:="USE"
	: ((_sql_tDialect="SqlServer") & ($1="USE DATABASE"))  //sql syntax by PM
		
		$0:="USE"
	: ((_sql_tDialect="Access") & ($1="USE DATABASE"))  //sql syntax by PM
		$0:="USE"
	: (($1="USE DATABASE"))  //sql syntax by PM
		$0:=""
		
	: ((_sql_tDialect="MySql") & ($1="text"))  //sql syntax by PM
		$0:="TEXT"
	: ((_sql_tDialect="MySql") & ($1="blob"))  //sql syntax by PM
		$0:="BLOB"
		
	: ((_sql_tDialect="Postgre") & ($1="text"))  //sql syntax by PM
		$0:="text"
	: ((_sql_tDialect="Postgre") & ($1="float"))  //sql syntax by PM
		$0:="double precision"
	: ((_sql_tDialect="Postgre") & ($1="blob"))  //sql syntax by PM
		$0:="bytea"
	: ((_sql_tDialect="Postgre") & ($1="picture"))  //sql syntax by PM
		$0:="bytea"
	: ((_sql_tDialect="Postgre") & ($1="tinyint"))  //sql syntax by PM
		$0:="smallint"  //= "int2"
		
	: ($1="LOWER_ORDER")
		$0:="LOWER"
		
	: ($1="0000-00-00 @")  //datetime
		$0:=ksQuoteSingle+"1970-01-01 "+Substring:C12($1; 12)+ksQuoteSingle
	: ((_sql_tDialect="Access") & ($1="0000-00-00"))  //date
		$0:="{ d '1970-01-01' }"
	: ($1="0000-00-00")  //date
		$0:=ksQuoteSingle+"1970-01-01"+ksQuoteSingle
	: ($1="00:00:00")  //time
		$0:=ksQuoteSingle+"00:00:00"+ksQuoteSingle
	: ($1="tinyint")  //sql syntax by PM
		$0:="integer"
	: ($1="blob")  //sql syntax by PM
		$0:="bit varying"
	: ($1="text")  //sql syntax by PM
		$0:="varchar"
	: ($1="boolean")  //sql syntax by PM
		$0:="bit"
	: ($1="picture")  //sql syntax by PM    
		//$0:="image"
		$0:="bit varying"
	Else 
		$0:=$1
End case 
